globals [ a1 a2 b1 b2 h K omega step w_max w0 w_fak r_fak die_list N_trees N_initial omega_tree omega_seed x y x_position y_position alfa beta w_rep zasieg_tree
  w_end_max seed_production c N_seeds how_many_times xx yy fi K_zasieg p pp]
  breed [trees tree]
  breed [seeds seed] 
  trees-own [ w age ]
  seeds-own [age]
 
to set-up
  clear-all
  set w0 20
  set a1 0.11
  set a2 0.03
  set b1 0.7
  set b2 0.9
  set h 2000 / wiek_tree_max
  set step 0
  set w_max w0
  set die_list []
  set w_fak Minimalna_masa_dla_przezycia 
  set r_fak Minimalna_masa_dla_reprodukcji
  set N_initial Początkowa_liczba_drzew
  set N_trees N_initial
  set N_seeds 0
  set x 0
  set y 0
  set alfa 1
  set beta Sila_konkurencji
  set w_end_max (a2 / a1) ^ (1 / (b1 - b2)) 
  set w_rep w_end_max * r_fak
  set c Produkcja_nasion 
  set fi Asymetria_konkurencji 
  set K_zasieg 100
  create-trees N_initial
  [  
  set size 2
  set shape "dot"
  set color white
  set age 0
  set w w0
  initial_space_distribution
  ]
 ask patches [set pcolor 23]
 set die_list lput (w0) die_list 
 reset-ticks
end

to wzorzec
 set step step + 1
 set w_max w_max + h * (a1 * w_max ^ b1 - a2 * w_max ^ b2) 
 set die_list lput (w_max * w_fak) die_list
 do-plots4
 if step > wiek_tree_max [stop]
end

to go
 ask trees
 [  
  tree_competition
  set age age + 1
  if age > wiek_tree_max [set N_trees N_trees - 1 die]
  set x_position xcor
  set y_position ycor  
  set K alfa * (w / (w + beta * omega_tree))
  set w w + h * (K * a1 * (w ^ b1) - a2 * w ^ b2)
  if w < item age die_list [set N_trees N_trees - 1 die]
  set zasieg_tree round (1 + zasieg_tree_max * ( w / ( K_zasieg + w )))
  set p random 10
  if w > w_rep and p <= Prawdopodobienstwo_reprodukcji * 10
  [set seed_production round (c * (w - w_rep))
   set color black set size 3 hatch-seeds seed_production 
  [set size 0.5 set shape "dot" set color yellow set age 0 set xcor random-normal x_position zasieg_tree  set ycor random-normal y_position zasieg_tree] set N_seeds N_seeds + seed_production]
 ]
ask seeds
 [
 seed_development
 set pp random 10 + 1
 ifelse (omega_seed = 0) and (not any? trees-on patch-here) and pp <= Prawdopodobienstwo_wykielkowania * 10
 [hatch-trees 1 [set size 2 set shape "dot" set color white set age 0  set w w0  set N_trees N_trees + 1] set N_seeds N_seeds - 1 die] 
 [set age age + 1 if age > wiek_seed_max [set N_seeds N_seeds - 1 die]]
 ]
 do-plots1
 do-plots2
 do-plots3
 do-plots4
 do-plots5
 do-plots6
 tick
 type ticks type "  " print N_trees
 if ticks > 2000 [stop]
end

to do-plots1
 set-current-plot "Rozkład mas drzew"
 set-current-plot-pen "pen2"
 set-histogram-num-bars 10
 histogram [w] of trees  
end
  
to do-plots2
 set-current-plot "Całkowita liczba drzew"
 set-current-plot-pen "trees"
 plot N_trees
end 
  
to do-plots3
 set-current-plot "Liczba nasion"
 set-current-plot-pen "pen1"
 plot N_seeds
end
  
to do-plots4
 set-current-plot "Wzorzec"
 set-current-plot-pen "w maks."
 plot w_max
 set-current-plot-pen "w reprod."
 plot w_rep
 set-current-plot-pen "w przezycia"
 plot item step die_list
end
 
to do-plots5
 set-current-plot "Liczba drzew dorosłych"
 set-current-plot-pen "pen3"
 plot count trees with [color = black]
end
 
to do-plots6
 set-current-plot "Liczba drzew młodych"
 set-current-plot-pen "pen4"
 plot count trees with [color = white ]
end
 
to tree_competition
 set how_many_times 2 * zasieg_tree + 1
 set omega_tree 0.0
 set xx (- zasieg_tree)
 repeat how_many_times 
  [
   set yy (- zasieg_tree) 
   repeat how_many_times  
  [
   if (xx != 0) or (yy != 0) [set omega_tree omega_tree + sum [w ^ fi] of trees-at xx yy / ((xx ^ 2 + yy ^ 2) ^ 0.5)]
   set yy yy + 1
  ]
   set xx xx + 1
  ]
end

to seed_development
 set how_many_times 2 * zasieg_seed + 1
 set omega_seed 0.0
 set xx  (- zasieg_seed)
 repeat how_many_times 
 [
  set yy  (- zasieg_seed) 
  repeat how_many_times  
 [
  if (xx != 0) or (yy != 0) [set omega_seed omega_seed + count [trees-at xx yy] of patch-here]
  set yy yy + 1
 ]
  set xx xx + 1
 ]
end

to initial_space_distribution
 loop [ set xcor random-xcor set ycor random-ycor if count turtles-on patch xcor ycor = 1 [stop]]
end

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
@#$#@#$#@
GRAPHICS-WINDOW
871
23
1334
507
-1
-1
4.09
1
10
1
1
1
0
1
1
1
0
110
0
110
0
0
1
ticks
30.0

BUTTON
793
39
860
72
NIL
set-up
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
796
125
859
158
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
795
83
858
116
wzorzec
wzorzec
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
602
362
848
505
Rozkład mas drzew
Ciężar
Liczba drzew
0.0
700.0
0.0
100.0
true
false
"" ""
PENS
"pen2" 100.0 1 -2674135 true "" ""

PLOT
9
174
296
346
Całkowita liczba drzew
Czas w latach
Liczba drzew
0.0
10.0
0.0
300.0
true
false
"" ""
PENS
"trees" 1.0 0 -14439633 true "" ""

SLIDER
8
10
202
43
Początkowa_liczba_drzew
Początkowa_liczba_drzew
0
100
1
1
1
NIL
HORIZONTAL

SLIDER
7
129
210
162
Produkcja_nasion
Produkcja_nasion
0
5
4
0.1
1
NIL
HORIZONTAL

SLIDER
10
85
206
118
Asymetria_konkurencji
Asymetria_konkurencji
0
3
2
0.1
1
NIL
HORIZONTAL

PLOT
315
171
575
348
Liczba nasion
Czas w latach
Liczba nasion
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen1" 1.0 0 -3844592 true "" ""

PLOT
604
172
847
323
Wzorzec
Czas w latach
Ciężar
0.0
90.0
0.0
700.0
false
true
"" ""
PENS
"w maks." 1.0 0 -7500403 true "" ""
"w reprod." 1.0 0 -2674135 true "" ""
"w przezycia" 1.0 0 -955883 true "" ""

SLIDER
218
48
456
81
Minimalna_masa_dla_reprodukcji
Minimalna_masa_dla_reprodukcji
0
1
0.95
0.01
1
NIL
HORIZONTAL

PLOT
312
356
575
504
Liczba drzew dorosłych
Czas w latach
Liczba drzew
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen3" 1.0 0 -13345367 true "" ""

PLOT
8
355
295
503
Liczba drzew młodych
Czas w latach 
Liczba drzew
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pen4" 1.0 0 -16777216 true "" ""

SLIDER
404
89
576
122
Wiek_tree_max
Wiek_tree_max
0
500
80
1
1
NIL
HORIZONTAL

SLIDER
10
46
204
79
Sila_konkurencji
Sila_konkurencji
0
1
1
0.01
1
NIL
HORIZONTAL

SLIDER
471
10
729
43
Prawdopodobienstwo_wykielkowania
Prawdopodobienstwo_wykielkowania
0
1
1
0.01
1
NIL
HORIZONTAL

SLIDER
218
10
456
43
Minimalna_masa_dla_przezycia
Minimalna_masa_dla_przezycia
0
1
0.65
0.01
1
NIL
HORIZONTAL

SLIDER
218
89
390
122
Zasieg_tree_max
Zasieg_tree_max
1
5
3
1
1
NIL
HORIZONTAL

SLIDER
219
130
391
163
Zasieg_seed
Zasieg_seed
1
3
1
1
1
NIL
HORIZONTAL

SLIDER
469
50
668
83
Prawdopodobienstwo_reprodukcji
Prawdopodobienstwo_reprodukcji
0
1
1
0.01
1
NIL
HORIZONTAL

SLIDER
401
129
573
162
Wiek_seed_max
Wiek_seed_max
0
50
20
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
